# 总论

过去三十年，开源软件以开放、共享、协同的新型生产方式，成为全球信息技术发展的强大推动力。中国开源的早期发展得益于开源的全球化进程，如今中国开源已经进入高速发展阶段，中国已经成为国际开源生态中不可或缺的参与者和重要贡献者，中国在全球开源事务中的影响力大幅提升。

回顾过去的一年，开源在全世界范围内迎来了大发展。根据多方数据显示，中国开源虽与欧美尚有明显差距，仍然处于追赶状态，但自2019年以来，中国开源的发展速度持续领跑全球，部分领域已经接近或达到世界先进水平。

近年来中国开源呈现出技术领域百花齐放，传统行业快速渗透的特点，产业界、学术界对共建开源生态的迫切性有了更深刻的理解，政府针对中国开源暴露出来的小、碎、散的特点，发挥有为政府的主动性，将发展开源明确地列入国家顶层规划《中华人民共和国国民经济和社会发展第十四个五年规划和2035年远景目标纲要》，为全行业全产业链传递重大利好，此举为中国开源全面高速发展添加了新引擎，提升了产业推动力。

尽管在各界同仁的共同努力下，中国开源在社区、基金会、孵化器、代码托管平台，以及教育、开源合规、知识产权保护、风险投资等开源基础设施和支撑体系建设方面，已取得较大进展，但部分环节仍然薄弱，中国开源的生态系统亟待专业化和系统化地建设和完善。中国开源要保持高速且稳步的发展，在积累储备开源人才、开源项目、开源社区和引导资金的前提下，应加大对弘扬开源文化、传承开源精神相关工作的重视；应尽快开展开源治理和社区运营等专业培训，应尽快对开源项目和开源社区开展市场咨询和商业孵化相关服务,在开源生态所面临的技术安全、知识产权、开源供应链（含断供）等风险领域，构筑产业合作框架，建立风险预警和应急预案机制。

2022年，我们的世界在疫情和俄乌冲突的双重影响下加速巨变，全球的政治、经济、军事格局正在重构，各国的科技创新之路或将走向殊途。近期欧美开源界出现的歧视事件引发了国人广泛关注和担忧，但中国开源爆发的惊人活力和上升势头确少有关注。歧视事件理应引起业内人士的重视，而不是全民的恐慌，在全球开源高速发展进程中，各国的实力和影响力此消彼长，放在更大的范围和更长时间周期上看，这些事件只是沧海一粟。中国开源要坚持战略定力和坚守战略耐心，不能闭门造车，更不该重复造轮子。不拒众流，方为江海。中国开源坚持在开放环境下自主创新，聚四海之气，借八方之力（摘自习近平， 2018年两院院士大会发言）。“危”之“机”所伏也，中国开源未来可期。

《2021年中国开源发展蓝皮书》发布之后，在国内外引起广泛关注，中国开源软件推进联盟及《2021中国开源发展蓝皮书》编辑部收到社会各界人士积极反馈。在此，我们表示真诚的感谢。

2022年，编辑部扩大了志愿编著团队，前后共吸引并接纳了80+名开源志愿者、40+家相关企业和组织机构参与贡献，大家齐心协作历时四个月共同编撰了《2022 中国开源发展蓝皮书》，希望能够为广大开源从业者、爱好者、用户，以及其他开源生态建设者、参与者，全面展现当前中国开源发展的全景图谱。

# 观点总览             

中国开源目前处于高速发展阶段，中国在国际开源事务中的影响力日渐提升，并在国际开源社区中贡献度不断增加。部分中国开源项目已接近或达到世界先进水平，包括像百度、华为、腾讯、阿里巴巴等一批有实力的中国IT技术公司，开始进入世界开源领跑者行列，同时也涌现出一些有全球影响力的杰出中国开源领袖。中国开源正从早期的使用者、跟随者、参与者，逐渐变成影响者、创作者和贡献者，中国开始涌现出越拉越多的开源开发者、开源项目、开源组织和开源企业。中国开源的发展与成果，成为推动开源产业持续创新的源泉，正在成为全球开源版图中的重要力量。
 
中国开源技术和产业在总体上与全球其他国家相比，正在接近一流水平，但尚有差距，仍然处于追赶状态。中国少数企业开始进入全球开源的领跑者队伍，并且涌现出少数杰出的开源领袖，中国开源的国际合作已日趋紧密。近年来，中国开源的发展正处于加速发展阶段，中国开源的贡献在全球逐渐得到了公认。
 
中国在开源的教育、标准化、立法、知识产权保护，以及开源技术、开源社区、基金会、孵化器、开源代码托管平台、风险投资、开源人才等开源基础设施和支撑体系建设方面，已取得较大进步，但部分环节仍然薄弱，急需体系化、系统化地建设和完善。中国开源要进一步坚实稳定发展，开源技术、开源人才、开源资金是必不可少的条件。开源平台、开源安全、开源供应链等问题与挑战需高度重视。
 
如今，开源已经成为全球的一种创新和协同模式，对开源本体和生态系统实行创新，并协同共建分布式数字主权和供应链，是当前中国开源发展的历史使命。
 
## 第一部分 中国开源历史

### “开源”概念

最早的“开源”是指开源软件，是指将源代码、设计文档或其他创作内容开放共享的一种技术开发和发行模式，简言之，开源指开源软件+软硬件设计文档，这是共享经济或创客早期的概念。时至今天，开源的概念已极大扩充，开源是指开源软件、开源硬件、开源生态、开源技术、开源社区、开源经济、开源商业模式、开源理念、开源文化、开源教育、开源许可证、开源基金会、开源孵化器、开源数字化治理体系、开源标准等一系列的总称。

### 中国开源起点

1991年中国与AT&T_Bell Laboratories USL/USG合作，引进UNIX SVR 4.2 版本源代码，并发布了中文版本，合作组建了中国UNIX公司；中方同时也引进“前UNIX”开放的源代码。1999年中国中科红旗、中软网络、冲浪平台在引进Red Hat公司Linux发行版的基础上，分别推出最早的Linux中文版本。 因此中国开源的发展历史，起始时间有两个重点节点：即1991年、1999年，至今分别是31年、23年。

### 中国开源贡献

根据中国开源软件推进联盟统计，在2016-2017年在华召开的开源国际会议上发表的论文中，来自国内和国外的的论文比例为4:6，即有40%的开源论文来自中国开发者。中国的开源力量正在以惊人的速度迎头赶上，在开源开发者贡献度、开源社区活跃度、开源基金会参与度等方面，我们均已取得了不俗的成绩。这些来自中国的开发者和科技企业正在向全世界呈现全新的中国印象，中国逐步实现了开源世界的大国担当。

* 中国开发者已成为Kernel.org社区最大贡献群体。
* 中国开发者成为RISC-V生态中不可或缺的组成部分。
* 中国用户和开发者已经成为OpenCV社区的中坚力量。
* 中国企业在开源基金会中发挥重要作用。
* 华为、阿里、百度、腾讯、中兴通讯、小米、滴滴、微众银行、浪潮软件、京东等中国头部科技企业贡献巨大。
* 中国原生开源企业加速涌现。


## 第二部分 中国开源现状 

### 中国开发者现状

* 据GitHub 统计，2020年较上一年新增了 1600 万开发者用户，预计2025 年开发者用户的数量将达到 1 亿。其中，在GitHub 的中国开发者数量及开源贡献度增长已成为全球最快，GitHub 预测到 2030 年中国开发者将成为全球最大的开源群体。
* 从中国的开源整体发展来看，中国开发者的影响力在加速增长：开发者对开源关注度持续升高；参与开源的人数持续增长；参与质量提升显著。这构成了中国开源产业的人才基础。
* 从贡献度来看，中国顶级开源项目的贡献度逐年增加，中国在国际开源事务中影响力日渐提升，并在国际社区中贡献度不断增加。 
* 开源已经成为基础设施的基石，数据显示，94%的开发者正在使用开源软件，仅有2%的开发者表示从未使用开源软件。

### 中国开源项目现状

* 开源在全球范围内发展迅速，过去五年商业代码库中开源代码增加2倍以上，中国超八成企业使用开源代码。
* 中国开源目前处于高速发展阶段：中国本土开源代码托管平台崛起，以 Gitee、Gitcode、木兰社区、Gitlink等为代表与国际知名开源社区、开源企业及开源基金会对接合作，大力发展中国开源项目建设。
* 中国目前处于开源高速发展的阶段，在新一代操作系统、分布式数据库、新一代人工智能框架等领域奋起直追，部分指标已经能够达到国际前沿的水平。
* 围绕中国开源市场的特点和当前技术发展，正在形成一些热点的产业生态：以芯片和操作系统为主的深度信息技术生态；多家开源数据库的创新生态；工业软件升级的工业互联网开源生态；以及最热点的包括人脸识别、自动驾驶在内的人工智能生态、中间件和云计算大数据产业生态等。
* 开源软件的发展从从操作系统开始，发展到数据库、中间件，并向应用领域逐渐延展，进而在近年来开始主导深度信息技术领域的创新：如，大数据、云计算、人工智能、区块链、IOT、云原生。目前来看，数据库领域的开源项目最为活跃；在新技术领域，人工智能、大数据、IoT表现突出；在操作系统领域，我国出现大量成熟的Linux发行版，很多企业成为Linux内核社区的主要贡献者，也逐渐出现自研开源的IOT实时操作系统（RTOS）；Web开发、移动端开发等应用领域繁荣发展。中国高度重视包括操作系统、云原生、大数据、数据库管理、区块链等重要领域的前瞻性布局，无论是项目活跃度，还是项目影响力，整体都在快速发展。
* 近年来我国开源企业及开发者逐渐深入深度信息技术领域的创新，涌现出如OpenHarmony（鸿蒙）、OpenEuler、PaddlePaddle、TiDB等非常优秀的开源项目，在未来将迎来更大的发展空间。
* 由中国人及中国企业发起或核心贡献的开源项目已经逐渐成为国际主流的开源项目。
* 相比价值已达数百亿美元的开源软件生态，芯片虽已成为支撑各行各业的基石，但开源芯片仍处于起步阶段。在处理器芯片领域，基于开源指令集 RISC-Ⅴ的开源芯片生态正在快速崛起，为开源芯片生态的创新降低了技术门槛，为包括中国在内的广大发展中国家突破中央处理器（CPU）芯片领域的技术垄断和市场垄断带来新机遇。
 
### 中国开源社区现状

* 中国开源社区当前正处于从早期的无序繁荣阶段向有序繁荣阶段的过渡期，国内的门户型社区、项目型社区和用户型社区正在快速演进，整体上处于转型的关键阶段。
* 中国本土开源代码托管平台崛起，以 Gitcode、Gitee、Gitlink为代表与国际知名开源社区、开源企业及开源基金会对接合作，大力发展中国开源社区建设；
* 开源社区追踪深度信息技术的崛起而更加多元化，其中，用户型社区和项目型社区得到产业关注和投资日益增加，平台型社区加速发展、商业模式清晰深受资本市场青睐。
* 中国开源社区蓬勃发展，项目型社区发展最显著。头部企业主导的项目社区，如百度旗下的飞浆和超级链、阿里旗下的龙蜥社区、腾讯云旗下的腾源会等，发展迅速。
* 区域性开源组织不断涌现，高校的学生开源俱乐部数量也在不断增加。增长最快是IT基础设施相关的开源项目社区。

### 中国开源商业现状

Red Hat在全球率先推出开源操作系统的商业模式，他们将服务确定为商业模式，实行开源软件免费、服务收费。但这种商业模式后来暴露出不少缺陷。一些企业将开源操作系统与电信营业、PC销售捆绑在一起，由电信、PC在销售中收费，开源从中提成。这种商业模式后来也暴露出一些问题，有待改进。
	
对于开源软件的发行版本，一般社区创新版是免费的，而基于社区版开发的企业版（或商业发行版）是需要收费的。企业版是基于稳定的社区版构建的，并配置安全模块和商业模式，进行二进制转换，开发硬件/芯片，建设生态和主导运维。
 
* 中国开源商业和开源投资同样处于快速发展阶段，大量投资机构亲睐和涌入开源领域。
* 近一年来，中国涌现了一批优秀的开源公司，相当一部分投资机构（大多为美元资本）非常看好这些中国的开源项目和其对应的商业模式，中国开源的商业化正进入快速发展。
* 但在头部项目获得资本青睐的同时，中国开源产业的规模化和生态发展，还需要更多腰部的优秀开源项目得到资金扶持和助力。此外，项目出海，走向全球化，也是中国优秀开源项目的努力方向。
* 目前较为流行的开源商业模式有：订阅式产品化和技术支持 –(RedHat 模式)、Dual-License 双授权模式、社区版开源，增值闭源的Open Core模式、SaaS - 软件即服务上云模式、广告收益型、软、硬一体化、附属品、降低用户TCO（捆绑软件或服务）、政府资助科研型和其他模式（利用开源软件来搭建应用系统，通过开源更快更便捷的获取基于开源操作系统的生态合作伙伴，通过开源生态上的产品分成等模式）。

### 中国开源教育现状   

* 开源教育正加速融入并贯穿教育全阶段：在人才培养的高中小学阶段，开源文化与技术逐渐渗入庞大的教学体系机制，高等院校开源教育从学生、教师自发开源教育行为转变为院校行为。
* 随着互联网技术的发展，开源相关培训、网络课程规模增多，开源职业教育跟随行业需求飞速发展。
* 开源教育平台和开源协作模式发展迅速：基于开发工具的开源教育平台支持大规模开源开发者分享开源技术、传播开源理念、推广开源项目；基于知识社区的开源教学平台提供了软件工程服务、讨论区、资源库等，形成了活跃的互动在线学习模式。
* 开源教育平台基于开放实践和开源竞赛：基于开放实践和开源竞赛的开源教育平台支持大规模开源开发者参与开源项目实训，该类平台以实践需要为导向，形成了产教一体化的在线学习模式。竞赛类学习平台主要采用在线编程竞赛的形式促进学习者进行程序设计语言学习、算法设计、编程应用等。
* 虽然中国开源教育模式众多，但开源人才与市场的需求仍然有着较大的差距，需不断探索校企结合的开源教育协同模式。
* 高校开源人才培养力度与开源生态蓬勃发展之间存在矛盾和鸿沟。
* 多主体开源教育协同机制及系统性架构发展仍在初级阶段，可持续运营模式尚待探索。
 
### 中国开源组织与生态系统现状 

* 中国开源基金会建设起步较晚，目前中国仅有一家开源基金会——开放原子开源基金会。
* 随着中国开源软件的快速发展，国内涌现出的越来越多开源组织，积极的为完善中国开源生态做出贡献。
* 在国家政策进一步利好的背景下，越来越多的第三方开源组织涌现，必将不断完善着我国的开源生态，为开源产业的发展贡献力量。
* 随着国家政策环境的持续优化，开源主题活动激增、内容丰富、形式多样。
* 开源生态系统并不是由纯开源软件所组成的，其中也包含闭源软件（如GMS中的谷歌地图、Gmail、Youtube等）。完整的开源生态包括：开源基金会、开源孵化器、开源社区、开源供应链、开源许可证、开源代码托管平台、以及开源政策、开源标准、开源治理体系等。
* 开源首次被写入国家“十四五”规划纲要后，越来越多的人和机构开始讨论开源、了解开源，各级政府部门越来越重视开源，新的开源组织也不断涌现，各种形式的开源活动也越来越频繁，中国开源生态呈现出前所未有的繁荣景象。
* 中国开源正从早期的使用者、跟随者、参与者，逐渐变成影响者、创作者和贡献者，中国开始涌现出越拉越多的开源开发者、开源项目、开源组织和开源企业。
* 中国首个开源协议“木兰宽松许可证”的诞生和中国首个开源基金会“开放原子开源基金会”的成立，标志着中国开源生态的逐渐完善。

## 第三部分 中国开源发展趋势

### 国际趋势：中国正在成为全球开源市场的增长点。 

* 中国市场越来越受开源项目青睐：中国的移动互联网和云计算发展很快，市场容量大，以云原生代表的新的订阅收费模式可以快速变现。
* 中国产业链越来越受开源项目青睐：中国具备全球最完善的电子制造业产业链，许多开源技术在这里找到载体最终销往全球各地，正如前文所说这种虹吸效应正在吸引越来越多的开源技术型企业加入到中国完善的产业链中，成为其中一部分，并越发的形成一个产业高地，不断从亚太甚至全球吸引技术人才和企业。
* 中国加快开源项目迭代速度：开源项目帮助很多中国中小企业先行先试，试好了直接就装上去，用起来，卖出去，效率大幅提升。中国市场成规模，在此基础上就可以形成一个快速迭代的优势。

### 中国开源开发者趋势。 

* 开源话题热度爆表，开源项目注重开发者生态建设，及技术内容运营。
* 众多开发者和技术内容创作者开始关注开源，产出开源技术内容。
* 开源技术活动井喷式增加。
* 大前端与跨平台开发、云原生、大数据、人工智能、开源基础设施（数据库、中间件、RISC-V、ARM 架构）、Web3 与区块链方向开源技术备受关注。

### 中国开源技术趋势：开源赋能深度信息技术，加速技术产业融合与创新。  

* 人工智能底层技术开源，将技术向传统企业生产、业务渗透，并积累行业数据资源，形成正反馈，实现人工智能与实体经济的深度融合。
* 充分利用已验证过的开源软件构建智能驾驶软件生态成为重要趋势，如在IVI应用方面普遍采用Android/Linux、开源通信中间件（DDS）框架、以及开源的机器学习框架等。
* 开源数据库通过源代码开放，为行业发展奠定了关键的技术基础，在开源的通用基础组件之上，已经蓬勃的生长出一系列的数据库产品，推动行业不断向前发展。数据库作为基础软件，在数字化时代正在发挥越来越重要的作用，中国数据库技术的发展经历了从开源受益到反馈开源社区，进而在全球社区中发挥核心影响力的阶段，通过国内根社区建设，参与国际开源社区，中国的开源数据库已经走上国际舞台，并逐渐形成创新引领的新趋势。
* 2021年AIoT行业继续保持快速增长，从独立的智能设备发展到整个连接的生态系统平台。开发人员将驱动哪个生态系统可能具有绝对优势，而开放平台将决定哪个平台可以吸引足够的开发人员。
* 元宇宙基础软件包括操作系统、数据库、编译器等，国内嵌入式操作系统厂商及时入局，融入元宇宙，加强元宇宙基础软件投入。

### 技术应用趋势：开源逐步渗透重点行业，促进数字化转型升级。

* 开源无论在中国还是世界范围内发展迅猛，中国传统企业开源使用、开源贡献、开源生态建设已取得成果，开源已向传统行业广泛渗透和深入。
* 传统行业开源代码使用率明显增长，新思科技2021年调研显示，与2019年调研数据相比，IOT、市场技术、教育行业开源使用率均有50%以上的增长。
* 开源贡献方面，金融、中国传统行业开源贡献起步，已涌现出一批解决行业痛点的高质量开源项目。其中，金融行业以微众银行为代表，2021年两个项目进入Apache孵化器，主要解决企业在云原生趋势下的架构、数据集成问题；电信行业国产运营商发起、参与推动了诸多面向5G场景，基于平台、关键部件、系统与集成领域的开源项目。
* 开源生态在传统行业建设已经取得进展，金融、电信、工业制造、汽车行业已形成行业特色开源社区。金融行业成立金融行业开源技术应用社区，电信行业成立通信行业开源社区（ICTOSC），工业制造行业成立工业技术软件化开源社区（OSIICN），汽车行业开源社区已在筹备中。
* 提升企业开发敏捷性和降本增效成为传统企业引入开源技术主要考量。由于开源协作有高效率、开发成本低的特点，可以帮助企业快速迭代软件，更快地响应业务变化、需求，这对于今天的传统企业至关重要。
* 传统企业引入开源技术的主要方式为制品环境组件级引入和商业解决方案间接引入。由于技术在传统企业内主要发挥业务支撑作用，传统企业更关注开源技术带来的价值而非对技术本身进行优化，因此相较代码级引入，制品环境组件级引入和商业解决方案间接引入更受传统企业青睐。
* 传统行业中，金融、电信、医疗行业的开源使用频繁，其中金融行业90%以上企业引入了开源技术，汽车行业近两年在智能汽车趋势下开源渗透率增长明显。
 
### 中国开源社区趋势。 

* 国内开源社区蓬勃发展，用户型社区占比最高，根据中国开源软件推进联盟最新统计，截止2021年2月20日，国内各种类型开源社区已经超过300个，按照门户型社区、项目型社区和用户型社区三类进行归总，其中约85%为用户型社区，约11%为项目型社区，4%为门户型社区。
* 中国开源社区迎来重要的发展阶段，正在从以学习应用国外开源项目和技术为主的爱好型社区为主，逐渐涌现一大批以应用、学习、贡献和开源创作的专业综合社区。社区走向专业在外部表现为和中国开源项目的蓬勃发展同频，在过去的2021年，由开源项目主办的开源社区发展也非常迅猛，从社区规模和内容、活动频次都呈现爆发之势。在社区内部，也越来越多的社区设置专职运营治理人员，从社区规划到成长计划到内容活动，开始走向专业规范治理运营。
* 随着国家不断加强对科技自主可控的宏观政策执行、数字化转型迫在眉睫以及开源写入到十四五规划中，各行各业都日益开始重视开源，特别是一批基础性的IT项目陆续开源，形成了一股强大的驱动力，驱动国内的开源社区的蓬勃发展。中国的开源社区未来可期，大有所为。

### 中国开源商业趋势。

* 在未来，中国将出现非常多且优秀的开源软件公司，立足全球化，主要体现为创始人具有中国背景，或者工程师大部分来自中国，但客户遍布世界各地。简言之，中国商业分层将更加清晰，对底层软件和开源软件形成利好之势。
* 中国开源公司有很大机会走向海外，这主要得益于中国的工程师红利、中国在互联网时代积累的场景红利。基础软件做得好不好，一个看技术，一个看是在什么场景下被锤炼出来。中国互联网有着全球最复杂的场景，一定能锤炼出一流的产品。
* 随着80后、90后成为创业者，成为企业中的购买决策者，大家在商业化上不再“犹抱琵琶半遮面”，不再遮遮掩掩，会直面自己的欲望 —— “我是好的产品，我就是要挣钱的”。买方和卖方都有这个意愿，对商业闭环的完成非常有利。
* 云化，云化能够提升开源软件的交付效率和商业效率，从买断式的版本，到SaaS按年付费，再到云上用多少就付多少，对于用户接纳产品有着积极意义。
随着信息化、数据化、智能化的深入发展，中国在ToB商业分层上将更加清晰，诸如声网（实时互动云服务商）这样专注于某个领域的公司会越来越多。分层出现后，对做底层软件和开源软件的开发者及企业而言，将是非常大的利好。

### 中国开源教育趋势：协同教育模式。

* **政府引导**。2020年6月20日，教育部办公厅、工业和信息化部办公厅联合印发《特色化示范性软件学院建设指南（试行）》提出，以特色化软件人才培养为目标，以深化产教融合为途径，以改革创新为驱动，以特色发展为重点，深化软件人才培养模式改革，大力开展关键核心软件技术攻关，促进软件生态体系建设，充分发挥软件人才培养对产业发展的支撑引领作用，推动我国软件产业实现由大到强的历史跨越。
* **高校、企业、社区、科研院所多方参与**。随着开源教育从传统理论课程向与实践结合的综合培养模式转变，高校、企业和开源社区、科研院所四方协作等协同创新模式不断被探索，共同培养开源人才的方式逐渐演变为未来发展趋势。
* **平台助力**。CCF作为中国计算机及相关领域具有广泛影响的学术团体，重点聚焦共同打造开源、开放、中立的产学研协同开源创新服务平台，通过培育原始开源创新项目，协同科教资源、产业资源和社会资源等探索产、教、研联动的开源创新模式，推动探索学术共同体主导的开源发展新途径，助力我国开源生态建设的发展。

### 开源组织与开源生态趋势。 

* 开源组织正在发展壮大成为生力军，随着从国家到企业对开源越来越重视、投入度越来越高，开源项目的发展也会迎来从量变到质变的飞跃。这些从快速发展的开源项目中成长起来的开源领军人才，精通技术与管理，熟悉开源沟通的方式与语言，预计将会成为未来我国开源组织建设的生力军。
* 我国已经成为国际开源社区发展最活跃的力量，主动构建开源软件生态，发布开源的根项目，并发挥我们统一大市场和高端软件人才的优势，引导市场主体和开源开发者拥抱原发于我国的开源软件，让更多的优质开源项目在中国生长繁茂，并走向世界。   

## 第四部分  中国开源面临挑战

###开源面临技术安全风险。

* 在开源的技术安全中，开源软件漏洞数量仍然保持高位。据Black Duck审计的1546个流行代码库中，98%的代码库包含开源代码，75%的代码由开源代码构成，84%的包含至少一个漏洞，每个代码库平均有158个漏洞，65%的代码库存在许可证冲突。
* 开源技术漏洞所影响的范围巨大。以2021年影响最大的Apache Log4j2漏洞事件为例，该漏洞可能导致设备远程受控，进而引发敏感信息窃取、设备服务中断等严重危害，属于高危漏洞。
* 根据奇安信代码安全实验室报告，输入验证、路径遍历、跨站脚本、注入、NULL引用、资源管理、密码管理、API误用、配置管理、日志伪造等十类安全缺陷是程序员在编写软件代码时经常会出现的典型安全缺陷。在2020年检测的1364个开源软件项目中，十类典型安全缺陷的总体检出率为56.3%。
 
### 开源面临的法律风险。 

* 目前对于开源社区常用的许可证有GPL、LGPL、MPL、Apache、BSD和MIT。开源相关的主要法律风险主要在于使用开源代码进行软件开发时，由于未遵守许可证（许可合同）而可能负有继续履行合同的义务或者可能承担版权侵权的责任，多为开源软件著作权风险和开源中的专利权风险。
* 近些年来随着开源软件在我国的发展，相关案例也渐渐出现，相关法律也并不健全。对于这个较新的领域来说，仍有待发展和探索。
* 传统企业在使用开源软件时对软件的安全性、稳定性和合规性存在担忧。

### 开源供应链风险。

* 持续维护风险。当前，大量软件产品依赖开源软件进行构建，这些被依赖的开源软件位居供应链上游，对下游产品安全具有重要的影响力。一旦这些上游开源软件由于某些原因不再进行维护，下游软件产品势必会受到影响；开源软件持续维护方面的另一个风险在于开源作者的付出与收益不相称。
* 安全漏洞风险。安全漏洞在流行开源项目中非常普遍。软件供应链的每个环节都可能会引入安全风险从而遭受攻击，上游环节的安全问题会传递到下游环节并被放大。攻击者不再等待公开的漏洞披露来进行漏洞利用，而是主动将新漏洞注入为全球供应链提供支持的开源项目中，通过将攻击转移到“上游”，可以获得影响力和关键的时间优势，使恶意软件能够在整个供应链中传播，从而对“下游”用户进行更具扩展性的攻击。
* 知识产权风险。
* 人为断供风险。需要引起重视的是，除了因美国法律要求“不得已”而为之的断供外，因政治立场、情感取向等非法律因素导致开源断供的行为也开始显现。除了直接断供外，还有舆论主张通过张贴标语表达政治倾向，越来越多的国际主流开源社区不得不在舆论的压力下做出表态，如Node.js、React.js等都曾在官网表明支持乌克兰的政治立场，不过后来都因引起网友的广泛关注和反应而最终删除相关观点。

### 开源产业发展的人才危机。   

* 放眼全球，开源人才短缺也是一个共性问题。在2020年就已经出现了开源人才招聘紧缺的现象，2022年这一现象仍在继续。据调查，12.7%的中国企业面临开源人才储备不足的困难。有一半的企业表示在未来6个月内将增加对于开源专业人员的招聘。
* 80%以上的企业开源人才缺口集中在30-50人。所缺乏开源人才的岗位类型多为开源开发者、开源社区运营。开源思维方式是招聘开源技术人才最看重的部分。企业招聘开源人才的最大难题是市场上合格人才数量有限，对人才的水平要求较高。
* 有38%的人表示，由于疫情，他们不得不增加开源人才招聘，这与许多企业在疫情的影响下加速数字化转型有关。几乎所有（97%）招聘经理而言，雇佣开源人才都变成了一个优先事项。
* 开源人才危机成因多与企业数字化转型加速，企业对开源技术的使用加大；开源人才供需对接的效率低；人才素质要求高、顶尖人才难寻；开源开发者在开源社区遇到歧视；企业存在人工成本居高不下，留存困难等因素相关。
* 对开源文化的普及与扩大：传统企业缺乏技术人才和对开源文化、开源生态的理解，制约开源技术在传统行业发展与进一步深入。

### 跨界创新完善机制迎接挑战。  

* 开源风险具有破坏性和长期性特点，已进入活跃期。
* 推进全球合作应对潜在风险，俄乌战争带来的提醒。
* 法律有国界、政治有立场、开源无歧视。在地缘政治可能影响一国的法律，在国家的法律可能影响平台服务，进而影响开源的时候。将平台放在任何一个国家，都是存在风险的。如果这个世界可能被割裂，无论代码仓库放在哪里，整个世界都会受到伤害。所以在建设中国开源平台的同时，更要努力建设不会被割裂的开源世界。
* 成立中国开源安全生态促进委员会，组建开源安全实验室。

## 第五部分 中国开源发展建议

### 加强开发者的运营与建设。

* 相对我国开源开发者群体数量，我们还没有出现足够数量的优秀开源项目，从基础来讲，我们需要进一步提升开源开发者研发和组织能力，通过普及开源技术和文化，提供开源知识库，专家库，推广开源项目，开源文化，进一步发展有实力的开源开发者生态。
* 加强企业开源建设：大量高技术的开发者都在企业，但多数企业缺乏开源文化和开源治理能力，可通过设置开源治理委员会或开发者生态联盟来推进：企业内还要鼓励开发者在使用开源项目的过程中，积极参与回馈开源社区。
* 加强开源文化的普及和运营：倡导开源精神，增强开发者对开源领域问题的研判及引领能力，积极引导开发人员参与新技术方向的探讨，鼓励开发者对开源领域问题提出自己的解决方案。
* 致力于提升开源治理能力，开源治理将会是未来科技软件实现快速发展的关键能力，对开源软件的社区治理模型的理解是开发者开发出有影响力的优秀开源项目的基础。
* 高校学生具备开源软件贡献者的特征，是开源开发者和爱好者的重要来源。高校应该在教学过程中推广开源教学方法，让学生掌握开源的基础技能；学生可以通过参与学习开源项目，在实践中学习知识，积累经验，提升协作能力和主动学习能力。
* 通过企业和高校的紧密合作，将开源生产环境与教学环境融合，成规模的为我国开源产业提供高层次高水准的开源软件开发者。

### 进一步促进开源社区发展壮大。

* 鼓励开发者社区发展，推动中国开源开发者的成长、开源应用及创作水平、开源文化的提升，为中国开源发展提供基础动力；加强开发者社区建设，提供开源知识库，专家库，推广开源项目，普及开源文化。
* 持续加强本土开源社区和开源代码托管平台的建设，为中国开源发展提供支撑性平台，鼓励开源开发者能够发现、交流、分享、创新应用及推广开源项目。
* 提高开源社区和开源项目的治理和运营能力，为开源社区治理专家、开源项目核心维护人员提供定向资助，让有实力有经验的专业人员，持续的专注于开源社区和项目的发展。

### 大力扶持优秀中国开源项目，加大产业生态。

* 人工智能等重大科技项目需要开源开放，需要以开源的形式提升创新质量，大量开源工具及平台，无不表明开源创新与协同有力推动了产业进程。
* 从开发模式角度，开源缩短了软件定义汽车的交付周期，以及降低成本。借鉴互联网时代的软件开发，构建完善的底层基础设施，如开发、持续集成和测试，发布与维护，以及OTA系统等，最好能实现自动化，共享开源平台，代码重复使用率高，开发过程更为高效，最大程度地降低企业研发费用，缩短新产品投放市场所需的时间，减少整个行业的分裂化发展趋势。同时也会带来新的问题，如使⽤开源软硬件，谁来承担安全责任和⻛险？
* 时至今日，开源软件依托其社区开发模式，能更快的实现产品迭代和用户触达，进而形成免费软件加付费服务的业务模式，并进一步通过云获得价值回报，MongoDB等数据库都在探索这一模式。此外，从市场竞争战略来看，软件开源已经成为后来者扩大其市场影响力、追赶头部企业的重要手段。
* 当前AIoT行业面临的两个主要挑战：平台安全性和缺乏行业标准。
 
### 打造新型产教融合平台，发展开源教育，培养开源人才。 

* 推动基于优秀国产开源成果的课程体系设计、师资队伍建设和培养计划制定，培养开源创新人才，支撑国产开源软件形成可持续发展生态。
* 加强开源文化和开源技能教育，建立鼓励软件成果开源的评价机制和价值导向，推动高校产出更多原创性开源成果。高校是科技创新的重要源头。我国高校亟需加强面向开源的软件教育。
* 以开源教育为抓手，打造新型产教融合平台，建立从高校开源学习、产业开源实践到开源创新创业的闭环，服务我国软件产业发展。开源教育应拓展到人才培养成长的各个阶段，需要相应平台和政策环境的支持。

### 建立丰富完善的中国开源生态，促进开源商业化。 

* 企业侧建立稳定的开源模式：我国自发开源企业需要建立稳定的开源商业模式，一是针对国际基金会顶级开源项目，建立社区反馈和联动机制：二是建立自主开源生态，重点在操作系统、数据库、中间件等基础软件领域探索开源。
* 第三方快速完善开源运营机制：一是国内开源联盟组织持续推进与企业的开源运营合作，借助联盟标准化与行业推广优势，推动我国自发开源项目应用；二是开源基金会形成稳定的决策机制，项目孵化流程，为国内开源项目运营提供有力知识产权托管以及法律、协作支撑。
* 构建开源治理体系：针对自发开源企业、开源使用企业建立开源软件管理体系，第三方组织需制定开源软件治理的行业标准，通过制定开源软件管理规则，帮助企业规范开源软件的使用和输出，实现企业软件的全覆盖和全流程管理，同时配套建设开源风险检测、开源生态监测等平台，推动企业落地开源冶理体系建设。
* 开源商业化的成功不仅仅取决于技术本身，对开源的信念、产品真正解决用户痛点需求缺一不可。一个商业化开源公司的成功需要方方面面，它需要整个团队往前推，不仅仅是技术团队在往前走，而是所有人同心协力往前走。要保证团队具备技术之外的壁垒，要补足团队的短板，比如开发者关系、市场契合度、设计团队甚至树立公司的品牌形象，都需要去做。 

### 持续加强中国开源基金会及开源组织建设。 

* 坚守并践行中立原则的开源基金会与开源组织将赢得开发者以及合作企业的持久信赖。
* 注重吸引全球的优秀项目与开发者，要推动形成统一的、你中有我我中有你的开源生态，不要割裂化、碎片化的全球开源生态。

### 加强行业标准与规范，解决开源供应链风险。   

* 利用开源技术修复和重建遭受破坏的供应链并迎接供应链中的安全挑战（LF开源大师Jim和Brian应邀于2022.1.13在美国白宫会议上发言，获得广泛共识）
整体考虑供应链上下游关系，明确开源软件供应链的各个环节组成。
* 应对软件供应链产品进行全生命周期安全保障，从上游开始一直到软件部署及运行，对各个环节进行安全评估。
* 从开发者、开源社区、地区分布等多个维度进一步评估关键开源软件的维护性和演化能力，确保其在供应链中的可靠性。
* 在上游开源软件和开源社区的基础上，由具有社会公信力的机构，牵头打造开源软件供应链基础设施，形成公共服务能力，对千行百业提供高质量、可持续的开源软件供应。
* 构建健全的开源供应链生态，一是注重培养开源软件供应链安全人才，二是构建开源供应链安全评估体系。扶持一批从事开源软件安全评估的创新企业，打造开源供应链的安全评估体系，三是建立开源供应链安全实验室。
* 为减轻开源企业对开源技术安全性、稳定性、合规性的顾虑，开源基金会、开源组织和行业联盟、企业应加强合作，加紧对开源行业整体标准、行业标准、企业标准的设立，并以此为依据加强对企业用户，开源开发者的教育、培训工作。

### 加强开源普及教育，发展中国开源人才。  

* 加强高校开源培养教育。
* 从开源项目团队或开源活动中直接引入人才。
* 针对开源人才形成体系的培养机制、对现有员工的培训；加大开源人才的加薪幅度、加强开源社区合作，促进整体生态繁荣。
* 科技企业、基金会、高校应注重开源技术人才的培养，为开发者了解开源、接触开源创造机会。

### 倡导全球化开源精神，推动中国开源发展，迎接挑战。  

* Apache创始人之一Brian Behlendorf 2007年在访华期间与我们有一段谈话：开源是利他主义（Altruism）的，或者说是共产主义（Communism）的，专用软件或私有软件当然是利己主义（Egoism）或资本主义（Capitalism）的，而开源的商业模式也是利己主义的。利他主义的开源与利己主义的商业模式结合在一起才能为开源做贡献。开源既含共产主义因素也含资本主义因素，既是商业的也是公益的或个人爱好的，而且还是学术的。
* 开源软件的协同特征有力地支持了未来互联网发展中分布式数字主权的建设。
* 面对一个急速变幻、急速下坠、甚至可能变得撕裂的世界，我们更应该推广开源精神，凝聚众人向善之力，汇聚众人向善之智，开放协作、互惠共赢，为这个世界变得更好做出贡献！
* 以全球开源的胸怀和视野，建立开源世界的反分裂共识，推广“更加完善的非歧视条款”开始，推动国际开源发展的繁荣。
